﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp" />
  <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory" />
  <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY" />
  <!-- Variable to hold cubic factor -->
  <xsl:variable name="cubicFactor">
    <xsl:choose>
      <xsl:when test="//@linearUnits = 'Imperial'">
        <xsl:choose>
          <xsl:when test="$xslConvertToCY = 1">27</xsl:when>
          <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <!-- End Area Volume Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">EAV Table Export</h2>
              </center>
              <!-- Cross Section Set Data -->
              <td align="left" lang="en" style="font-size: 80%">Right-click and Export to Excel. Place Table using "End Area Volume" Seed. Format: Sta, Cut Area, Cut Vol, Fill Area, Fill Volume, Mass Ordinate)</td>
              <hr></hr>
              <xsl:for-each select="CrossSectionSet">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr></tr>
                    <tr></tr>
                    <tr></tr>
                  </tbody>
                </table>
                <!-- Volume Data -->
                <table width="100%">
                  <xsl:for-each select="CrossSectionStations">
                    <xsl:for-each select="CrossSectionStation">
                      <tbody>
                        <xsl:apply-templates />
                      </tbody>
                      <tfoot style="display:table-footer-group">
                        <xsl:if test="position() = last()">
                          <xsl:call-template name="grandTotal">
                            <xsl:with-param name="allVolumes" select="../*/StationVolume" />
                          </xsl:call-template>
                        </xsl:if>
                      </tfoot>
                    </xsl:for-each>
                  </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="StationVolume | DerivedStationVolume">
    <tr>
      <td align="center" nowrap="nowrap">
        <xsl:value-of select="cif:stationFormat(number(../Station/@externalStation), string(../Station/@externalStationName))" />
      </td>
      <td align="right">
        <xsl:value-of select="cif:areaFormat(number(CutMaterial/@area))" />
      </td>
      <td align="right">
        <xsl:value-of select="cif:cubicFormat(number(CutMaterial/@volume div $cubicFactor))" />
      </td>
      <td align="right">
        <xsl:value-of select="cif:areaFormat(number(FillMaterial/@area))" />
      </td>
      <td align="right">
        <xsl:value-of select="cif:cubicFormat(number(FillMaterial/@volume div $cubicFactor))" />
      </td>
      <td align="right">
        <xsl:value-of select="cif:cubicFormat(number(@massOrdinate div $cubicFactor))" />
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="grandTotal">
    <xsl:param name="allVolumes" />
    <tr>
      <th align="center" colspan="1">Totals:</th>
      <th colspan="1"> </th>
      <th align="right">
        <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/CutMaterial/@cumulativeVolume div $cubicFactor))"></xsl:value-of>
      </th>
      <th colspan="1"> </th>
      <th align="right">
        <xsl:value-of select="cif:cubicFormat(number($allVolumes[position() = last()]/FillMaterial/@cumulativeVolume div $cubicFactor))" />
      </th>
    </tr>
    <tr>
      <td colspan="16">
        <hr />
      </td>
    </tr>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <p class="normal1" lang="en">
            This report has no additional notes.
        </p>
  </xsl:template>
</xsl:stylesheet>